File: /adapters/cursor/examples/generate-ui-button.md

# Example — Generate UI Button (Free Edition)

This example demonstrates how to generate a Button component
using SaaS OS Free Edition rules.

---

## Objective

Create or update a `ui-button` component
that strictly follows the SaaS OS Button contract.

---

## Required Authority

Before prompting Cursor, confirm this file exists:

SaaS-OS-Free-v1.0/docs/engineering/contracts/Contract — ui-button.md

This contract is authoritative.

If the contract is missing, STOP.

---

## Prompt to Use in Cursor

Read:
- SaaS-OS-Free-v1.0/docs/engineering/contracts/Contract — ui-button.md

Task:
Create or overwrite the file:

components/ui-button.tsx

Rules:
- Follow the contract exactly.
- Do not add new props.
- Do not add new variants.
- Do not add implicit state.
- Do not add timing logic.
- Use SaaS OS token variables only.
- Preserve semantic HTML (use <button>).

If any requirement is unclear, STOP and ask.

Output:
- Write changes directly to components/ui-button.tsx
- Do not output explanation text unless explicitly requested.

---

## Validation Checklist

After generation, confirm:

- No hardcoded colors or spacing
- No additional props beyond contract definition
- No internal state unless defined in the contract
- Token variables are used consistently

If violations exist:
1. Reject the output
2. Tighten the prompt
3. Regenerate

Manual patching is discouraged.